/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;

public class JsonHelper {
    private JsonHelper() {
    }

    public static JsonElement getElement(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> List<T> parseList(JsonArray array, String name, BiFunction<JsonElement, String, T> mapper) {
        if (array.size() == 0) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.apply(array.get(i), name + "[" + i + "]"));
        }
        return builder.build();
    }

    public static <T> List<T> parseList(JsonArray array, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(array, name, (JsonElement element, String s) -> mapper.apply(class_3518.method_15295((JsonElement)element, (String)s)));
    }

    public static <T> List<T> parseList(JsonObject parent, String name, BiFunction<JsonElement, String, T> mapper) {
        return JsonHelper.parseList(class_3518.method_15261((JsonObject)parent, (String)name), name, mapper);
    }

    public static <T> List<T> parseList(JsonObject parent, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(class_3518.method_15261((JsonObject)parent, (String)name), name, mapper);
    }

    public static class_2960 getResourceLocation(JsonObject json, String key) {
        String text = class_3518.method_15265((JsonObject)json, (String)key);
        class_2960 location = class_2960.method_12829((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a Resource location, was '" + text + "'");
        }
        return location;
    }

    public static class_2960 getResourceLocation(JsonObject json, String key, class_2960 fallback) {
        if (json.has(key)) {
            return JsonHelper.getResourceLocation(json, key);
        }
        return fallback;
    }

    public static class_2960 convertToResourceLocation(JsonElement json, String key) {
        String text = class_3518.method_15287((JsonElement)json, (String)key);
        class_2960 location = class_2960.method_12829((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a Resource location, was '" + text + "'");
        }
        return location;
    }

    public static <T> T convertToEntry(class_2378<T> registry, JsonElement element, String key) {
        Object value;
        class_2960 name = JsonHelper.convertToResourceLocation(element, key);
        if (registry.method_10250(name) && (value = registry.method_10223(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unknown " + registry + " " + name);
    }

    public static <T> T getAsEntry(class_2378<T> registry, JsonObject parent, String key) {
        return JsonHelper.convertToEntry(registry, JsonHelper.getElement(parent, key), key);
    }

    private static <T extends Enum<T>> T enumByName(String name, Class<T> enumClass) {
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            if (!value.name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return (T)value;
        }
        throw new JsonSyntaxException("Invalid " + enumClass.getSimpleName() + " " + name);
    }

    public static <T extends Enum<T>> T convertToEnum(JsonElement element, String key, Class<T> enumClass) {
        String name = class_3518.method_15287((JsonElement)element, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    public static <T extends Enum<T>> T getAsEnum(JsonObject json, String key, Class<T> enumClass) {
        String name = class_3518.method_15265((JsonObject)json, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    public static int parseColor(@Nullable String color) {
        if (color == null || color.isEmpty()) {
            return -1;
        }
        if (color.charAt(0) != '-') {
            try {
                int length = color.length();
                if (length == 8) {
                    return (int)Long.parseLong(color, 16);
                }
                if (length == 6) {
                    return 0xFF000000 | Integer.parseInt(color, 16);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new JsonSyntaxException("Invalid color '" + color + "'");
    }

    @Nullable
    public static JsonObject getJson(class_3298 resource) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resource.method_43039();
            try {
                jsonObject = class_3518.method_15255((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    Mantle.logger.error("Failed to load JSON from resource " + resource.method_14480(), e);
                    return null;
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    public static List<JsonObject> getFileInAllDomainsAndPacks(class_3300 manager, String path, @Nullable String preferredPath) {
        return manager.method_14487().stream().filter(class_2960::method_20209).flatMap(namespace -> {
            class_2960 location = new class_2960(namespace, path);
            return manager.method_14489(location).stream();
        }).map(preferredPath != null ? resource -> {
            String loaded = resource.method_45304().method_14409();
            Mantle.logger.warn("Using deprecated path {} in pack {} - use {}:{} instead", (Object)loaded, (Object)resource.method_14480(), (Object)loaded, (Object)preferredPath);
            return JsonHelper.getJson(resource);
        } : JsonHelper::getJson).filter(Objects::nonNull).toList();
    }

    private static void sendPackets(NetworkWrapper network, class_3222 player, ISimplePacket[] packets) {
        if (!player.field_13987.field_14127.method_10756()) {
            for (ISimplePacket packet : packets) {
                network.sendTo(packet, player);
            }
        }
    }

    public static void syncPackets(class_3222 targetedPlayer, boolean joined, NetworkWrapper network, ISimplePacket ... packets) {
        JsonHelper.sendPackets(network, targetedPlayer, packets);
    }

    public static class_2680 convertToBlockState(JsonElement element, String key) {
        if (element.isJsonPrimitive()) {
            return ((class_2248)JsonHelper.convertToEntry(class_7923.field_41175, element, key)).method_9564();
        }
        if (element.isJsonObject()) {
            return JsonHelper.convertToBlockState(element.getAsJsonObject());
        }
        throw new JsonSyntaxException("Expected " + key + " to be a string or an object, was " + class_3518.method_15266((JsonElement)element));
    }

    public static class_2680 getAsBlockState(JsonObject parent, String key) {
        if (parent.has(key)) {
            return JsonHelper.convertToBlockState(parent.get(key), key);
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find a string or an object");
    }

    private static <T extends Comparable<T>> class_2680 setValue(class_2680 state, class_2769<T> property, String name) {
        Optional value = property.method_11900(name);
        if (value.isPresent()) {
            return (class_2680)state.method_11657(property, (Comparable)value.get());
        }
        throw new JsonSyntaxException("Property " + property + " does not contain value " + name);
    }

    public static class_2680 convertToBlockState(JsonObject json) {
        class_2248 block = (class_2248)JsonHelper.getAsEntry(class_7923.field_41175, json, "block");
        class_2680 state = block.method_9564();
        if (json.has("properties")) {
            class_2689 definition = block.method_9595();
            for (Map.Entry entry : class_3518.method_15296((JsonObject)json, (String)"properties").entrySet()) {
                String key = (String)entry.getKey();
                class_2769 property = definition.method_11663(key);
                if (property == null) {
                    throw new JsonSyntaxException("Property " + key + " does not exist in block " + block);
                }
                state = JsonHelper.setValue(state, property, class_3518.method_15287((JsonElement)((JsonElement)entry.getValue()), (String)key));
            }
        }
        return state;
    }

    public static JsonElement serializeBlockState(class_2680 state) {
        class_2248 block = state.method_26204();
        if (state == block.method_9564()) {
            return new JsonPrimitive(Objects.requireNonNull(class_7923.field_41175.method_10221((Object)block)).toString());
        }
        return JsonHelper.serializeBlockState(state, new JsonObject());
    }

    private static <T extends Comparable<T>> void serializeProperty(class_2680 serialize, class_2769<T> property, class_2680 defaultState, JsonObject json) {
        Comparable value = serialize.method_11654(property);
        if (!value.equals(defaultState.method_11654(property))) {
            json.addProperty(property.method_11899(), property.method_11901(value));
        }
    }

    public static JsonObject serializeBlockState(class_2680 state, JsonObject json) {
        class_2248 block = state.method_26204();
        json.addProperty("block", Objects.requireNonNull(class_7923.field_41175.method_10221((Object)block)).toString());
        class_2680 defaultState = block.method_9564();
        JsonObject properties = new JsonObject();
        for (class_2769 property : block.method_9595().method_11659()) {
            JsonHelper.serializeProperty(state, property, defaultState, properties);
        }
        if (properties.size() > 0) {
            json.add("properties", (JsonElement)properties);
        }
        return json;
    }
}

